/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.mixin.client;

import com.mojang.authlib.GameProfile;
import dev.muon.medievalorigins.power.PixieWingsPower;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends Player {
    @Unique
    private static final int TICK_INTERVAL = 2;
    @Unique
    private static final double GROUND_DISTANCE_THRESHOLD = 0.1;

    public AbstractClientPlayerMixin(Level pLevel, BlockPos pPos, float pYRot, GameProfile pGameProfile) {
        super(pLevel, pPos, pYRot, pGameProfile);
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        if (player.f_19797_ % 2 == 0 && PixieWingsPower.hasPower((Entity)player)) {
            if (player.m_150110_().f_35935_) {
                player.f_108542_ = 1.4981318f;
                player.f_108543_ = 0.58726645f;
                player.f_108544_ = -1.2853982f;
            } else {
                boolean isCloseToGround;
                Vec3 playerMovement = player.m_20184_();
                if (playerMovement.f_82480_ < -0.5) {
                    return;
                }
                double speedMagnitude = Math.sqrt(playerMovement.f_82479_ * playerMovement.f_82479_ + playerMovement.f_82481_ * playerMovement.f_82481_ + Math.max(playerMovement.f_82480_, 0.0) * Math.max(playerMovement.f_82480_, 0.0)) * 4.0;
                float flapStrength = (float)Math.min(speedMagnitude, 1.0);
                Vec3 startPos = player.m_20182_();
                Vec3 endPos = startPos.m_82520_(0.0, -1.0, 0.0);
                BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                boolean bl = isCloseToGround = hitResult.m_6662_() != HitResult.Type.MISS && hitResult.m_82450_().m_82554_(startPos) <= 0.1;
                if (player.m_21255_() || playerMovement.f_82480_ > 0.1 || player.m_150110_().f_35935_ || !isCloseToGround && Math.abs(playerMovement.f_82479_) + Math.abs(playerMovement.f_82481_) > 0.1) {
                    player.f_108542_ = 1.4981318f * flapStrength;
                    player.f_108543_ = 0.58726645f * flapStrength;
                    player.f_108544_ = -1.2853982f * flapStrength;
                }
            }
        }
    }
}

